<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="xml" indent="yes"/>

    <xsl:template match="/">
        <Table key="PL_DEMO_PRODUCTS">
            <Items>
                <xsl:apply-templates select="Csv-To-Xml/File/Rows/R[position() > 1]" />
            </Items>
        </Table>
    </xsl:template>

    <xsl:template match="Csv-To-Xml/File/Rows/R">
        <Item partition="ACTIVES">
            <xsl:apply-templates select="C" />
        </Item>
    </xsl:template>

    <xsl:template match="C">
        <xsl:variable name="j" select="@j"/>
        <xsl:variable name="key" select="../../R[@i=1]/C[@j=$j]"/>
        <xsl:variable name="value" select="normalize-space(.)"/>
        <xsl:choose>
            <xsl:when test="$key = 'EAN_13'">
                <xsl:element name="Identifier">
                    <xsl:attribute name="key">
                        <xsl:value-of select="$key"/>
                    </xsl:attribute>
                    <xsl:value-of select="$value"/>
                </xsl:element>
            </xsl:when>
            <xsl:when test="$key = 'TYPOLOGY'">
                <xsl:element name="Classification">
                    <xsl:attribute name="key">
                        <xsl:value-of select="$key"/>
                    </xsl:attribute>
                    <xsl:value-of select="$value"/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="Field">
                    <xsl:attribute name="key">
                        <xsl:value-of select="$key"/>
                    </xsl:attribute>
                    <xsl:value-of select="$value"/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>